//
@import <Foundation/CPObject.j>
@import "RMControllerObject.j"



@implementation JasperSoftReporter: RMControllerObject {

    id          myRepo;
    id          jsprHost;//    @accessors;
    id          jsprMsql;//    @accessors;
    id          jsprUser;//    @accessors;
    id          prefiURL;//    @accessors;
    id          rprtFldr;//    @accessors;
    id          dataSour;//    @accessors;
    id          myHost;  //    @accessors;
    id          contView;
}


- (void)  applicationQuit {
    if (myRepo)   { [myRepo    release];}
    if (jsprHost) { [jsprHost  release];}
    if (jsprMsql) { [jsprMsql  release];}
    if (jsprUser) { [jsprUser  release];}
    if (prefiURL) { [ prefiURL release];}
    if (rprtFldr) { [rprtFldr  release];}
    if (dataSour) { [ dataSour release];}
    if (myHost)   { [myHost    release];}
    if (contView) { [ contView release];}

}




- (CPString) buildJasperURL:(CPDictionary)thisRprtData {

     // Contenido del diccionario
     // title          - ...                                                : titulo del reporte
     // headList       - ...                                                : Lista de encabezados de las tablas del report
     // repoCode       - ...                                                : Codigo del reporte
     // comment        - ...                                                : comentario
     // testFoot       - ...                                                : Texto del Pie de pagina
     // sourceOfData   - ...                                                : nombre de la base de datos
     // myModel        - ...                                                : Nombre del modelo de reporte que se utilizara
     // myPath         - ...                                                : Trajectoria del reporte solicitado
     // headYear       - ...                                                : Año para el que se realiza el calendario
     // userAlias      - ...                                                : Nombre del cliente
     // Task_1,Task_2,Task_3,Task_4,Task_5,Task_6,Task_7,Task_8             : Cada una de las tareas que se incluiran en el calendario
     // Notes          - ...                                                : Notas que se incluiran en el calendario
     myRepo = thisRprtData;

     // Se creza el String de parametros a incluir en la URL
     var myParms = "";
     var myPath  = [myRepo objectForKey:@"myPath"];
     var myKeys  = [myRepo allKeys]; 
     
      var myModel  = [myRepo objectForKey:@"myModel"];
      [myRepo removeObjectForKey:@"myModel"];
     var sepa    = "";
     for ( var i=0; i < [myRepo count]; i++ ) {
         var aKey = [myKeys objectAtIndex:i];
         var aObj = [myRepo objectForKey:aKey];
         if ( aObj ) {
            if ( ![aKey isEqualToString:@"myPath"] ) {
                 //myParms += sepa + aKey + "=" + [aObj stringByReplacingOccurrencesOfString:@" " withString:@"%20"] ;
                 myParms += sepa + aKey + "=" + aObj;
                 sepa = "&";
            }
         }
     }
     myParms  = myParms;
     rprtFldr = "&ParentFolderUri=" + myPath ;
     dataSour = "&reportUnit=" + myPath + "/" + myModel;

    var FINAURL = jsprHost + prefiURL + rprtFldr + dataSour;
    //FINAURL = FINAURL + "/" + myName;
    //FINAURL = FINAURL + myName;
   //    FINAURL = FINAURL + "&" + myPrms + userPass; //Original
    FINAURL = FINAURL + "&" + myParms + jsprUser;

    console.log(FINAURL);
    return FINAURL;
}



- (id) init:(id)paraAppCont {

    self = [super init];
    
    appCont = paraAppCont;
    dataBase = [appCont getDataBase];

    jsprMsql = "b14_2"; 
    jsprHost = "http://167.250.194.153:8080/jasperserver/";
    jsprUser = "&j_username=orkin&j_password=orkinpassw&decorate=no";
    prefiURL = "flow.html?_flowId=viewReportFlow&output=pdf&userLocale=es_ES&standAlone=true&_flowId=viewReportFlow";
    return self;
}





- (void) showPreviousView:(CPString)_jsprURL {
    
    var frame  = CGRectMake(100,100,800,400);
    var wind   = [[CPWindow alloc] initWithContentRect:frame styleMask:CPHUDBackgroundWindowMask|CPTitledWindowMask|CPClosableWindowMask|CPWindowWillCloseNotification|CPResizableWindowMask];
    var _aView = [wind contentView];
    var wid    = [_aView frame].size.width;
    var hei    = [_aView frame].size.height;
    contView   = [[CPView alloc] initWithFrame:CGRectMake(0,13, wid,hei - 13)];
    [_aView setBackgroundColor:[CPColor colorWithRed:55./255. green:65.0/255.0 blue:75.0/255.0 alpha:1.0]];
  
    [ _aView addSubview:contView];
    [contView setAutoresizingMask:CPViewWidthSizable | CPViewHeightSizable];
    var newIfrm = document.createElement("iframe");
    newIfrm.setAttribute("src",_jsprURL);
    newIfrm.setAttribute("style", "height: 100%; width: 100%");
    contView._DOMElement.appendChild(newIfrm);
    [wind orderFront:self];
}



//- (void) emailReportToList:(CPArray)_mailList :(CPDictionary)thisRprtData { //Original
- (void) emailReportToList:(CPArray)_mailList :(CPString)paraURLRepo :(CPString)commEmai{
    //var urlLink = [self buildJasperURL:thisRprtData];
    //alert("url repo 1 " + paraURLRepo );
    var urlLink = escape(paraURLRepo);
      //alert("url repo 2 " + paraURLRepo )
    //urlLink = [urlLink stringByReplacingOccurrencesOfString:@"https://" withString:@""];
    //urlLink = [urlLink stringByReplacingOccurrencesOfString:@"https%3A//" withString:@""];
    //alert("url repo 3 " + urlLink ) 
    /*
    body = "Estimado cliente.\n";
    body += "Usted esta recibiendo un reporte enviado por ORKIN S.A.\n";
    body += "Por favor presione el link que se muestra abajo para visualizarlo \n\n ";
    body += urlLink + "\n\n" ;
    body += commEmai;
    body += "\n Route Intelligence Team ";
    var  subj = "Reporteria Orkin: " ;
    */
    
    var quer = "";
    var emaiAddr;
    var pend = 0;
    var sendPers = "Se envio el reporte a:\n ";
    for ( var i = 0; i < [_mailList count]; i++ ) {
        
          var destinatario = [_mailList objectAtIndex:i];
          emaiAddr = [_mailList objectAtIndex:i];

          // QUERY  para insertar en riglobal.notifierpendingList
          //quer = [CPString stringWithFormat:@"INSERT INTO riglobal.notifierpendingList (mailAddress,mailBody,pending,subject) VALUES ('%@','%@','%@','%@')",
                    //  emaiAddr,body,pend,subj];
          //console.log("enviar a: " + emaiAddr);
          sendPers += " " + emaiAddr + "\n";
          [self sendEmailGET:emaiAddr urlLink:urlLink commEmai:commEmai];
          //[self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
          //sendEmailGET
          //[self sendEmailGET:emaiAddr urlLink:urlLink commEmai:commEmai];
          
        }
                
        
        emaiAddr = "dastua@orkincr.com";
        sendPers += " " + emaiAddr + "\n";
        [self sendEmailGET:emaiAddr urlLink:urlLink commEmai:commEmai];

        emaiAddr = "programacion@orkincr.com";
        sendPers += " " + emaiAddr + "\n";
        [self sendEmailGET:emaiAddr urlLink:urlLink commEmai:commEmai];
        //[self query:quer];

        /*
        emaiAddr = "alonso.villanueva@route-miner.com";
        sendPers += " " + emaiAddr + "\n";
        [self sendEmailGET:emaiAddr urlLink:urlLink commEmai:commEmai];
        */
      
        
        [glblAlerPane showWithMessage:@"Atencion" info:sendPers];

    }

@end